<?php
// Configuration settings
define('DATA_DIR', __DIR__ . '/../data');
define('URLS_FILE', DATA_DIR . '/urls.json');
define('VISITS_FILE', DATA_DIR . '/visits.json');

/**
 * Automatically detect BASE_URL with correct protocol and path
 */
function getBaseUrl() {
    // Detect HTTPS
    $protocol = 'http';
    if (
        (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ||
        (!empty($_SERVER['HTTP_X_FORWARDED_PROTO']) && $_SERVER['HTTP_X_FORWARDED_PROTO'] === 'https') ||
        (!empty($_SERVER['HTTP_X_FORWARDED_SSL']) && $_SERVER['HTTP_X_FORWARDED_SSL'] === 'on') ||
        (!empty($_SERVER['SERVER_PORT']) && $_SERVER['SERVER_PORT'] == 443)
    ) {
        $protocol = 'https';
    }
    
    // Get host
    $host = $_SERVER['HTTP_HOST'];
    
    // Get current script directory path
    $scriptDir = dirname($_SERVER['SCRIPT_NAME']);
    
    // Remove trailing slash if exists
    $scriptDir = rtrim($scriptDir, '/');
    
    // Build base URL
    $baseUrl = $protocol . '://' . $host . $scriptDir;
    
    return $baseUrl;
}

// Define BASE_URL after function declaration
$base_url = getBaseUrl();
define('BASE_URL', $base_url);

// Create data directory if it doesn't exist
if (!is_dir(DATA_DIR)) {
    mkdir(DATA_DIR, 0755, true);
}

// Create JSON files if they don't exist
if (!file_exists(URLS_FILE)) {
    file_put_contents(URLS_FILE, json_encode([]));
}

if (!file_exists(VISITS_FILE)) {
    file_put_contents(VISITS_FILE, json_encode([]));
}

// IP Geolocation API settings
define('IPAPI_URL', 'http://ip-api.com/json/');
define('IPINFO_URL', 'https://ipapi.co/');

// User agent detection
define('BOT_PATTERNS', [
    'bot', 'crawler', 'spider', 'scraper', 'facebook', 'twitter', 'google',
    'bing', 'yahoo', 'baidu', 'yandex', 'duckduck', 'archive', 'wget',
    'curl', 'python', 'php', 'java', 'perl', 'ruby', 'node', 'http'
]);

// Hosting/VPS/Cloud providers (comprehensive list)
define('HOSTING_ASNS', [
    // Major Cloud Providers
    'Amazon', 'AWS', 'Google', 'Microsoft', 'Azure', 'GCP', 'Google Cloud',
    // VPS/Hosting Providers
    'DigitalOcean', 'Linode', 'Vultr', 'Hetzner', 'OVH', 'Scaleway', 'Contabo',
    'HostGator', 'GoDaddy', 'Namecheap', 'DreamHost', 'Bluehost', 'InMotion',
    // CDN/Proxy Services
    'Cloudflare', 'Fastly', 'MaxCDN', 'KeyCDN', 'CloudFront', 'Akamai',
    // Datacenter/Hosting Companies
    'Rackspace', 'IBM Cloud', 'Alibaba Cloud', 'Tencent Cloud', 'Baidu Cloud',
    'Oracle Cloud', 'VMware', 'UpCloud', 'Kamatera', 'A2 Hosting', 'SiteGround',
    'Hostinger', 'InterServer', 'Liquid Web', 'WP Engine', 'Kinsta',
    // Common Hosting/VPS Companies (Real World)
    'Psychz Networks', 'Psychz', 'HostRush', 'ReliableSite', 'ReliableSite.Net',
    'Limestone Networks', 'ColoCrossing', 'Choopa', 'ServerMania', 'WebNX',
    'QuadraNet', 'Wholesale Internet', 'Colocrossing', 'FDCservers', 'ServerHub',
    'DataShack', 'Hostway', 'Softlayer', 'LeaseWeb', 'Nobis Technology',
    'M247', 'HostDime', 'ServerCheap', 'VirMach', 'BuyVM', 'RamNode',
    'HostUS', 'BudgetVM', 'Crissic Solutions', 'SecuredServers', 'Dacentec',
    'PhoenixNAP', 'GlobalFrag', 'TurnKey Internet', 'Online.net', 'Gandi.net',
    'HostEurope', 'Strato', '1&1', 'Host1Plus', 'Time4VPS', 'AlphaRacks',
    'VPS', 'Virtual Private Server', 'Dedicated Server', 'Cloud Server',
    'Hosting', 'Datacenter', 'Data Center', 'Colocation', 'Colo', 'Hosting Services',
    'Web Hosting', 'Server Hosting', 'Cloud Hosting', 'Managed Hosting'
]);

// VPN/Proxy service patterns
define('VPN_PATTERNS', [
    // VPN Services
    'vpn', 'proxy', 'tor', 'anonymous', 'private', 'secure', 'tunnel',
    'expressvpn', 'nordvpn', 'surfshark', 'cyberghost', 'purevpn', 'hotspot shield',
    'protonvpn', 'windscribe', 'tunnelbear', 'hide.me', 'zenmate', 'vpnbook',
    'hidemyass', 'ipvanish', 'vypr', 'strongvpn', 'privatevpn', 'buffered',
    // Proxy Services
    'squid', 'proxy server', 'socks', 'http proxy', 'https proxy',
    'transparent proxy', 'elite proxy', 'high anonymity', 'residential proxy',
    'datacenter proxy', 'rotating proxy', 'mobile proxy'
]);

// Suspicious/Threat indicators
define('THREAT_PATTERNS', [
    'abuse', 'spam', 'malware', 'botnet', 'honeypot', 'scanner',
    'attack', 'malicious', 'blacklist', 'reputation', 'threat'
]);
?>
